<div class="col">
    <div class="metrics-container">

        <div class="row">
            <div class="mb-4 col-md-4">
                <div class="card shadow rounded py-2 px-3">
                    <div class="card-body text-muted font-weight-medium">
                        <p class="font-weight-bolder fs-5 mb-3">Last 24 hours</p>
                        <p class="">{{__("Users registered")}}: {{\App\Providers\DashboardServiceProvider::getLast24HoursRegisteredUsersCount()}}</p>
                        <p class="">{{__("New posts")}}: {{\App\Providers\DashboardServiceProvider::getLast24HoursPostsCount()}}</p>
                        <p class="">{{__("New subscriptions")}}: {{\App\Providers\DashboardServiceProvider::getLast24HoursSubscriptionsCount()}}</p>
                        <p class="m-0">{{__("Total earned")}}: {{\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\DashboardServiceProvider::getLast24HoursTotalEarned())}}</p>
                        <span class="pull-right"><a href="admin/users" class="primary-link">{{__("Go to users")}} ››</a></span>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>

            <div class="mb-4 col-md-4">

                <div class="card shadow rounded py-2 px-3">
                    <div class="card-body text-muted font-weight-medium">
                        <p class="font-weight-bolder fs-5 mb-3">Payments</p>
                        <p>{{__("Active subscriptions")}}: {{\App\Providers\DashboardServiceProvider::getActiveSubscriptionsCount()}}</p>
                        <p>{{__("Subscriptions revenue")}}: {{\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\DashboardServiceProvider::getTotalSubscriptionsRevenue())}}</p>
                        <p>{{__("Total transactions")}}: {{\App\Providers\DashboardServiceProvider::getTotalTransactionsCount()}}</p>
                        <p class="m-0">{{__("Total amount earned")}}: {{\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\DashboardServiceProvider::getTotalEarned())}}</p>
                        <span class="pull-right"><a href="admin/transactions" class="primary-link">{{__("Go to payments")}} ››</a></span>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>

            <div class="mb-4 col-md-4">

                <div class="card shadow rounded py-2 px-3">
                    <div class="card-body text-muted font-weight-medium">
                        <p class="font-weight-bolder fs-5 mb-3">Content</p>
                        <p>{{__("Total jobs")}}: {{\App\Providers\DashboardServiceProvider::getPostsCount()}}</p>
                        <p>{{__("Total companies")}}: {{\App\Providers\DashboardServiceProvider::getCompaniesCount()}}</p>
                        <p>{{__("Total applicants")}}: {{\App\Providers\DashboardServiceProvider::getApplicantsCount()}}</p>
                        <p class="m-0">{{__("User reports")}}: {{\App\Providers\DashboardServiceProvider::getReportsCount()}}</p>
                        <span class="pull-right"><a href="admin/jobs" class="primary-link">{{__("Go to content")}} ››</a></span>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row two-columns-graph-holder">
            @include('elements.admin.value_card', [
                'name' => 'newUsersValue',
                'route' => 'admin.metrics.new.users.value',
                'size' => 'col-xs-12 col-sm-12 col-md-6 col-lg-6',
                'title' => __('New users'),
                'form' => [
                    'trans' => [__('Day'), __('Days')],
                    'function' => 'count',
                    'ranges' => [1, 7, 14, 30, 60, 90],
                    'range' => 30
                ]
            ])
            @include('elements.admin.partition_card', [
                'name' => 'rolesPerUser',
                'chart' => [
                    'size' => 180,
                    'color' => '245, 85, 54',
                    'total' => true
                ],
                'route' => 'admin.metrics.new.users.partition',
                'size' => 'col-xs-12 col-sm-12 col-md-6 col-lg-6',
                'title' => __('Users roles'),
                'form' => [
                    'function' => 'count',
                ]
            ])
        </div>
        <div class="row">
            @include('elements.admin.trend_card', [
                'name' => 'newUsersTrend',
                'chart' => [
                    'size' => 100,
                    'color_start' => 'rgba(245, 85, 54)',
                    'color_stop' => 'rgba(243, 145, 126, 0.5)',
                    'border_color' => 'rgba(255, 41, 0, 0.7)',
                    'point_radius' => 10,
                    'total' => true
                ],
                'route' => 'admin.metrics.new.users.trend',
                'size' => 'col-12 col-lg-12 mb-4',
                'title' => __('Registered users'),
                'form' => [
                    'trans' => [__('Month'), __('Months')],
                    'function' => 'count',
                    'unit' => 'month',
                    'ranges' => [3, 6, 12],
                    'range' => 12
                ]
            ])
        </div>
    </div>
</div>
