<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DataRowsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('data_rows')->delete();
        
        \DB::table('data_rows')->insert(array (
            0 => 
            array (
                'id' => 1,
                'data_type_id' => 1,
                'field' => 'id',
                'type' => 'number',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 1,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            1 => 
            array (
                'id' => 2,
                'data_type_id' => 1,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            2 => 
            array (
                'id' => 3,
                'data_type_id' => 1,
                'field' => 'email',
                'type' => 'text',
                'display_name' => 'Email',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            3 => 
            array (
                'id' => 4,
                'data_type_id' => 1,
                'field' => 'password',
                'type' => 'password',
                'display_name' => 'Password',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 1,
                'add' => 1,
                'delete' => 0,
                'details' => '{}',
                'order' => 5,
            ),
            4 => 
            array (
                'id' => 5,
                'data_type_id' => 1,
                'field' => 'remember_token',
                'type' => 'text',
                'display_name' => 'Remember Token',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 7,
            ),
            5 => 
            array (
                'id' => 6,
                'data_type_id' => 1,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 27,
            ),
            6 => 
            array (
                'id' => 7,
                'data_type_id' => 1,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 23,
            ),
            7 => 
            array (
                'id' => 8,
                'data_type_id' => 1,
                'field' => 'avatar',
                'type' => 'image',
                'display_name' => 'Avatar',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            8 => 
            array (
                'id' => 9,
                'data_type_id' => 1,
                'field' => 'user_belongsto_role_relationship',
                'type' => 'relationship',
                'display_name' => 'Role',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 0,
                'details' => '{"model":"TCG\\\\Voyager\\\\Models\\\\Role","table":"roles","type":"belongsTo","column":"role_id","key":"id","label":"display_name","pivot_table":"roles","pivot":"0","taggable":"0"}',
                'order' => 11,
            ),
            9 => 
            array (
                'id' => 10,
                'data_type_id' => 1,
                'field' => 'user_belongstomany_role_relationship',
                'type' => 'relationship',
                'display_name' => 'Roles',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{"model":"TCG\\\\Voyager\\\\Models\\\\Role","table":"roles","type":"belongsToMany","column":"id","key":"id","label":"display_name","pivot_table":"user_roles","pivot":"1","taggable":"0"}',
                'order' => 12,
            ),
            10 => 
            array (
                'id' => 11,
                'data_type_id' => 1,
                'field' => 'settings',
                'type' => 'hidden',
                'display_name' => 'Settings',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 14,
            ),
            11 => 
            array (
                'id' => 12,
                'data_type_id' => 2,
                'field' => 'id',
                'type' => 'number',
                'display_name' => 'ID',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 1,
            ),
            12 => 
            array (
                'id' => 13,
                'data_type_id' => 2,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 2,
            ),
            13 => 
            array (
                'id' => 14,
                'data_type_id' => 2,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 3,
            ),
            14 => 
            array (
                'id' => 15,
                'data_type_id' => 2,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 4,
            ),
            15 => 
            array (
                'id' => 16,
                'data_type_id' => 3,
                'field' => 'id',
                'type' => 'number',
                'display_name' => 'ID',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            16 => 
            array (
                'id' => 17,
                'data_type_id' => 3,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            17 => 
            array (
                'id' => 18,
                'data_type_id' => 3,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 3,
            ),
            18 => 
            array (
                'id' => 19,
                'data_type_id' => 3,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            19 => 
            array (
                'id' => 20,
                'data_type_id' => 3,
                'field' => 'display_name',
                'type' => 'text',
                'display_name' => 'Display Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            20 => 
            array (
                'id' => 21,
                'data_type_id' => 1,
                'field' => 'role_id',
                'type' => 'text',
                'display_name' => 'Role',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            21 => 
            array (
                'id' => 22,
                'data_type_id' => 4,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            22 => 
            array (
                'id' => 23,
                'data_type_id' => 4,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            23 => 
            array (
                'id' => 24,
                'data_type_id' => 4,
                'field' => 'total',
                'type' => 'text',
                'display_name' => 'Total',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            24 => 
            array (
                'id' => 27,
                'data_type_id' => 4,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            25 => 
            array (
                'id' => 28,
                'data_type_id' => 4,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 8,
            ),
            26 => 
            array (
                'id' => 29,
                'data_type_id' => 6,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 1,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            27 => 
            array (
                'id' => 30,
                'data_type_id' => 6,
                'field' => 'filename',
                'type' => 'text',
                'display_name' => 'Filename',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            28 => 
            array (
                'id' => 31,
                'data_type_id' => 6,
                'field' => 'driver',
                'type' => 'select_dropdown',
                'display_name' => 'Driver',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"0","options":{"0":"Local","1":"S3","2":"Wasabi","3":"DigitalOcean","4":"Minio","5":"Pushr"}}',
                'order' => 6,
            ),
            29 => 
            array (
                'id' => 32,
                'data_type_id' => 6,
                'field' => 'type',
                'type' => 'text',
                'display_name' => 'Type',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            30 => 
            array (
                'id' => 33,
                'data_type_id' => 6,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            31 => 
            array (
                'id' => 35,
                'data_type_id' => 6,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            32 => 
            array (
                'id' => 36,
                'data_type_id' => 6,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 10,
            ),
            33 => 
            array (
                'id' => 37,
                'data_type_id' => 9,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            34 => 
            array (
                'id' => 38,
                'data_type_id' => 9,
                'field' => 'from_user_id',
                'type' => 'text',
                'display_name' => 'From User Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            35 => 
            array (
                'id' => 39,
                'data_type_id' => 9,
                'field' => 'to_user_id',
                'type' => 'text',
                'display_name' => 'To User Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            36 => 
            array (
                'id' => 40,
                'data_type_id' => 9,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Type',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"tip","options":{"tip":"Tip","reaction":"Reaction","new-comment":"Comment","new-subscription":"Subscription","withdrawal-action":"Withdrawal","new-message":"Message"}}',
                'order' => 11,
            ),
            37 => 
            array (
                'id' => 41,
                'data_type_id' => 9,
                'field' => 'post_id',
                'type' => 'text',
                'display_name' => 'Post Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            38 => 
            array (
                'id' => 42,
                'data_type_id' => 9,
                'field' => 'post_comment_id',
                'type' => 'text',
                'display_name' => 'Post Comment Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            39 => 
            array (
                'id' => 43,
                'data_type_id' => 9,
                'field' => 'subscription_id',
                'type' => 'text',
                'display_name' => 'Subscription Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            40 => 
            array (
                'id' => 44,
                'data_type_id' => 9,
                'field' => 'transaction_id',
                'type' => 'text',
                'display_name' => 'Transaction Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            41 => 
            array (
                'id' => 45,
                'data_type_id' => 9,
                'field' => 'reaction_id',
                'type' => 'text',
                'display_name' => 'Reaction Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            42 => 
            array (
                'id' => 46,
                'data_type_id' => 9,
                'field' => 'message',
                'type' => 'text',
                'display_name' => 'Message',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 13,
            ),
            43 => 
            array (
                'id' => 47,
                'data_type_id' => 9,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 15,
            ),
            44 => 
            array (
                'id' => 48,
                'data_type_id' => 9,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 16,
            ),
            45 => 
            array (
                'id' => 49,
                'data_type_id' => 10,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            46 => 
            array (
                'id' => 50,
                'data_type_id' => 10,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            47 => 
            array (
                'id' => 51,
                'data_type_id' => 10,
                'field' => 'post_id',
                'type' => 'text',
                'display_name' => 'Post Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            48 => 
            array (
                'id' => 52,
                'data_type_id' => 10,
                'field' => 'message',
                'type' => 'text',
                'display_name' => 'Message',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            49 => 
            array (
                'id' => 53,
                'data_type_id' => 10,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            50 => 
            array (
                'id' => 54,
                'data_type_id' => 10,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 7,
            ),
            51 => 
            array (
                'id' => 55,
                'data_type_id' => 11,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            52 => 
            array (
                'id' => 56,
                'data_type_id' => 11,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            53 => 
            array (
                'id' => 57,
                'data_type_id' => 11,
                'field' => 'text',
                'type' => 'text',
                'display_name' => 'Text',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            54 => 
            array (
                'id' => 58,
                'data_type_id' => 11,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"requested","options":{"0":"Pending","1":"Approved","2":"Disapproved"}}',
                'order' => 5,
            ),
            55 => 
            array (
                'id' => 59,
                'data_type_id' => 11,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            56 => 
            array (
                'id' => 60,
                'data_type_id' => 11,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 7,
            ),
            57 => 
            array (
                'id' => 61,
                'data_type_id' => 12,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            58 => 
            array (
                'id' => 62,
                'data_type_id' => 12,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            59 => 
            array (
                'id' => 63,
                'data_type_id' => 12,
                'field' => 'post_id',
                'type' => 'text',
                'display_name' => 'Post Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            60 => 
            array (
                'id' => 64,
                'data_type_id' => 12,
                'field' => 'post_comment_id',
                'type' => 'text',
                'display_name' => 'Post Comment Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            61 => 
            array (
                'id' => 65,
                'data_type_id' => 12,
                'field' => 'reaction_type',
                'type' => 'text',
                'display_name' => 'Reaction Type',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            62 => 
            array (
                'id' => 66,
                'data_type_id' => 12,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            63 => 
            array (
                'id' => 67,
                'data_type_id' => 12,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 8,
            ),
            64 => 
            array (
                'id' => 68,
                'data_type_id' => 13,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            65 => 
            array (
                'id' => 71,
                'data_type_id' => 13,
                'field' => 'paypal_agreement_id',
                'type' => 'text',
                'display_name' => 'Paypal ID',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            66 => 
            array (
                'id' => 72,
                'data_type_id' => 13,
                'field' => 'stripe_subscription_id',
                'type' => 'text',
                'display_name' => 'Stripe ID',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 11,
            ),
            67 => 
            array (
                'id' => 73,
                'data_type_id' => 13,
                'field' => 'paypal_plan_id',
                'type' => 'text',
                'display_name' => 'Paypal Plan ID',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            68 => 
            array (
                'id' => 74,
                'data_type_id' => 13,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Type',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"one-month-subscription","options":{"one-month-subscription":"One month sub","three-months-subscription":"Three months sub","six-months-subscription":"Six months sub","yearly-subscription":"Yearly sub"}}',
                'order' => 13,
            ),
            69 => 
            array (
                'id' => 75,
                'data_type_id' => 13,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"pending","options":{"pending":"Pending","completed":"Completed","suspended":"Suspended","update-needed":"Update needed","canceled":"Canceled","expired":"Expired"}}',
                'order' => 14,
            ),
            70 => 
            array (
                'id' => 76,
                'data_type_id' => 13,
                'field' => 'expires_at',
                'type' => 'timestamp',
                'display_name' => 'Expires At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 16,
            ),
            71 => 
            array (
                'id' => 77,
                'data_type_id' => 13,
                'field' => 'canceled_at',
                'type' => 'timestamp',
                'display_name' => 'Canceled At',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 17,
            ),
            72 => 
            array (
                'id' => 78,
                'data_type_id' => 13,
                'field' => 'amount',
                'type' => 'text',
                'display_name' => 'Amount',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 15,
            ),
            73 => 
            array (
                'id' => 79,
                'data_type_id' => 13,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 18,
            ),
            74 => 
            array (
                'id' => 80,
                'data_type_id' => 13,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 19,
            ),
            75 => 
            array (
                'id' => 81,
                'data_type_id' => 14,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            76 => 
            array (
                'id' => 84,
                'data_type_id' => 14,
                'field' => 'subscription_id',
                'type' => 'text',
                'display_name' => 'SubscriptionID',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            77 => 
            array (
                'id' => 86,
                'data_type_id' => 14,
                'field' => 'stripe_transaction_id',
                'type' => 'text',
                'display_name' => 'StripeTransactionID',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            78 => 
            array (
                'id' => 87,
                'data_type_id' => 14,
                'field' => 'stripe_session_id',
                'type' => 'text',
                'display_name' => 'StripeSessionID',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 11,
            ),
            79 => 
            array (
                'id' => 88,
                'data_type_id' => 14,
                'field' => 'paypal_transaction_id',
                'type' => 'text',
                'display_name' => 'PaypalTransactionID',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 12,
            ),
            80 => 
            array (
                'id' => 89,
                'data_type_id' => 14,
                'field' => 'paypal_transaction_token',
                'type' => 'text',
                'display_name' => 'PaypalTransactionToken',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 13,
            ),
            81 => 
            array (
                'id' => 90,
                'data_type_id' => 14,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"pending","options":{"pending":"Pending","canceled":"Canceled","approved":"Approved","declined":"Declined","refunded":"Refunded","initiated":"Initiated","partially-paid":"Partially paid"}}',
                'order' => 15,
            ),
            82 => 
            array (
                'id' => 91,
                'data_type_id' => 14,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Type',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"tip","options":{"one-month-subscription":"One month sub","yearly-subscription":"Yearly sub","subscription-renewal":"Subscription renewal"}}',
                'order' => 16,
            ),
            83 => 
            array (
                'id' => 92,
                'data_type_id' => 14,
                'field' => 'payment_provider',
                'type' => 'select_dropdown',
                'display_name' => 'Payment Provider',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"stripe","options":{"stripe":"Stripe","paypal":"Paypal","ccbill":"CCBill","coinbase":"Coinbase","nowpayments":"Nowpayments","paystack":"Paystack","oxxo":"Oxxo"}}',
                'order' => 17,
            ),
            84 => 
            array (
                'id' => 93,
                'data_type_id' => 14,
                'field' => 'currency',
                'type' => 'text',
                'display_name' => 'Currency',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 19,
            ),
            85 => 
            array (
                'id' => 94,
                'data_type_id' => 14,
                'field' => 'paypal_payer_id',
                'type' => 'text',
                'display_name' => 'PaypalPayerId',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 14,
            ),
            86 => 
            array (
                'id' => 95,
                'data_type_id' => 14,
                'field' => 'amount',
                'type' => 'text',
                'display_name' => 'Amount',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 21,
            ),
            87 => 
            array (
                'id' => 96,
                'data_type_id' => 14,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 25,
            ),
            88 => 
            array (
                'id' => 97,
                'data_type_id' => 14,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 27,
            ),
            89 => 
            array (
                'id' => 98,
                'data_type_id' => 15,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            90 => 
            array (
                'id' => 99,
                'data_type_id' => 15,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            91 => 
            array (
                'id' => 100,
                'data_type_id' => 15,
                'field' => 'post_id',
                'type' => 'text',
                'display_name' => 'Post Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            92 => 
            array (
                'id' => 101,
                'data_type_id' => 15,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            93 => 
            array (
                'id' => 102,
                'data_type_id' => 15,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 6,
            ),
            94 => 
            array (
                'id' => 103,
                'data_type_id' => 16,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            95 => 
            array (
                'id' => 104,
                'data_type_id' => 16,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            96 => 
            array (
                'id' => 105,
                'data_type_id' => 16,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            97 => 
            array (
                'id' => 106,
                'data_type_id' => 16,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Type',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"followers","options":{"followers":"Followers","blocked":"Blocked","custom":"Custom"}}',
                'order' => 5,
            ),
            98 => 
            array (
                'id' => 107,
                'data_type_id' => 16,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            99 => 
            array (
                'id' => 108,
                'data_type_id' => 16,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 7,
            ),
            100 => 
            array (
                'id' => 109,
                'data_type_id' => 17,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            101 => 
            array (
                'id' => 110,
                'data_type_id' => 17,
                'field' => 'list_id',
                'type' => 'text',
                'display_name' => 'List Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            102 => 
            array (
                'id' => 111,
                'data_type_id' => 17,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            103 => 
            array (
                'id' => 112,
                'data_type_id' => 17,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            104 => 
            array (
                'id' => 113,
                'data_type_id' => 17,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 7,
            ),
            105 => 
            array (
                'id' => 114,
                'data_type_id' => 18,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            106 => 
            array (
                'id' => 115,
                'data_type_id' => 18,
                'field' => 'sender_id',
                'type' => 'text',
                'display_name' => 'Sender Id',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            107 => 
            array (
                'id' => 116,
                'data_type_id' => 18,
                'field' => 'receiver_id',
                'type' => 'text',
                'display_name' => 'Receiver Id',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            108 => 
            array (
                'id' => 117,
                'data_type_id' => 18,
                'field' => 'replyTo',
                'type' => 'text',
                'display_name' => 'ReplyTo',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            109 => 
            array (
                'id' => 118,
                'data_type_id' => 18,
                'field' => 'message',
                'type' => 'text',
                'display_name' => 'Message',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            110 => 
            array (
                'id' => 119,
                'data_type_id' => 18,
                'field' => 'isSeen',
                'type' => 'text',
                'display_name' => 'IsSeen',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            111 => 
            array (
                'id' => 120,
                'data_type_id' => 18,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            112 => 
            array (
                'id' => 121,
                'data_type_id' => 18,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 10,
            ),
            113 => 
            array (
                'id' => 122,
                'data_type_id' => 19,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            114 => 
            array (
                'id' => 123,
                'data_type_id' => 19,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            115 => 
            array (
                'id' => 124,
                'data_type_id' => 19,
                'field' => 'amount',
                'type' => 'text',
                'display_name' => 'Amount',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            116 => 
            array (
                'id' => 125,
                'data_type_id' => 19,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"requested","options":{"requested":"Requested","rejected":"Rejected","approved":"Approved"}}',
                'order' => 5,
            ),
            117 => 
            array (
                'id' => 126,
                'data_type_id' => 19,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            118 => 
            array (
                'id' => 127,
                'data_type_id' => 19,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 8,
            ),
            119 => 
            array (
                'id' => 128,
                'data_type_id' => 20,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            120 => 
            array (
                'id' => 129,
                'data_type_id' => 20,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            121 => 
            array (
                'id' => 130,
                'data_type_id' => 20,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            122 => 
            array (
                'id' => 131,
                'data_type_id' => 20,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            123 => 
            array (
                'id' => 132,
                'data_type_id' => 21,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            124 => 
            array (
                'id' => 133,
                'data_type_id' => 21,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            125 => 
            array (
                'id' => 134,
                'data_type_id' => 21,
                'field' => 'percentage',
                'type' => 'text',
                'display_name' => 'Value',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"If tax type is \'Fixed\' this value represents a fixed amount, otherwise it is a percentage from the payment amount"}',
                'order' => 3,
            ),
            126 => 
            array (
                'id' => 135,
                'data_type_id' => 21,
                'field' => 'type',
                'type' => 'radio_btn',
                'display_name' => 'Type',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"inclusive","options":{"inclusive":"Inclusive","exclusive":"Exclusive","fixed":"Fixed"}}',
                'order' => 4,
            ),
            127 => 
            array (
                'id' => 136,
                'data_type_id' => 21,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            128 => 
            array (
                'id' => 137,
                'data_type_id' => 21,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 6,
            ),
            129 => 
            array (
                'id' => 138,
                'data_type_id' => 21,
                'field' => 'tax_belongstomany_country_relationship',
                'type' => 'relationship',
                'display_name' => 'Countries',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Country","table":"countries","type":"belongsToMany","column":"id","key":"id","label":"name","pivot_table":"country_taxes","pivot":"1","taggable":"0"}',
                'order' => 7,
            ),
            130 => 
            array (
                'id' => 142,
                'data_type_id' => 14,
                'field' => 'taxes',
                'type' => 'text',
                'display_name' => 'Taxes',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 23,
            ),
            131 => 
            array (
                'id' => 145,
                'data_type_id' => 1,
                'field' => 'bio',
                'type' => 'text',
                'display_name' => 'Bio',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            132 => 
            array (
                'id' => 146,
                'data_type_id' => 1,
                'field' => 'location',
                'type' => 'text',
                'display_name' => 'Location',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            133 => 
            array (
                'id' => 147,
                'data_type_id' => 1,
                'field' => 'website',
                'type' => 'text',
                'display_name' => 'Website',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            134 => 
            array (
                'id' => 148,
                'data_type_id' => 1,
                'field' => 'cover',
                'type' => 'text',
                'display_name' => 'Cover',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 13,
            ),
            135 => 
            array (
                'id' => 149,
                'data_type_id' => 1,
                'field' => 'email_verified_at',
                'type' => 'timestamp',
                'display_name' => 'Email verified',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 24,
            ),
            136 => 
            array (
                'id' => 150,
                'data_type_id' => 1,
                'field' => 'public_profile',
                'type' => 'checkbox',
                'display_name' => 'Public Profile',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 15,
            ),
            137 => 
            array (
                'id' => 152,
                'data_type_id' => 1,
                'field' => 'billing_address',
                'type' => 'text',
                'display_name' => 'Billing Address',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 16,
            ),
            138 => 
            array (
                'id' => 153,
                'data_type_id' => 1,
                'field' => 'first_name',
                'type' => 'text',
                'display_name' => 'First Name',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 17,
            ),
            139 => 
            array (
                'id' => 154,
                'data_type_id' => 1,
                'field' => 'last_name',
                'type' => 'text',
                'display_name' => 'Last Name',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 18,
            ),
            140 => 
            array (
                'id' => 155,
                'data_type_id' => 1,
                'field' => 'city',
                'type' => 'text',
                'display_name' => 'City',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 19,
            ),
            141 => 
            array (
                'id' => 156,
                'data_type_id' => 1,
                'field' => 'country',
                'type' => 'text',
                'display_name' => 'Country',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 20,
            ),
            142 => 
            array (
                'id' => 157,
                'data_type_id' => 1,
                'field' => 'state',
                'type' => 'text',
                'display_name' => 'State',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 21,
            ),
            143 => 
            array (
                'id' => 158,
                'data_type_id' => 1,
                'field' => 'postcode',
                'type' => 'text',
                'display_name' => 'Postcode',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 22,
            ),
            144 => 
            array (
                'id' => 159,
                'data_type_id' => 27,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 1,
            ),
            145 => 
            array (
                'id' => 160,
                'data_type_id' => 27,
                'field' => 'slug',
                'type' => 'text',
                'display_name' => 'Slug',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            146 => 
            array (
                'id' => 161,
                'data_type_id' => 27,
                'field' => 'title',
                'type' => 'text',
                'display_name' => 'Title',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            147 => 
            array (
                'id' => 162,
                'data_type_id' => 27,
                'field' => 'content',
                'type' => 'rich_text_box',
                'display_name' => 'Content',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
            'details' => '{"tinymceOptions":{"toolbar":"undo redo | formatselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | fontsizeselect","plugins":"lists link image","image_title":true,"automatic_uploads":false,"file_picker_types":"image","image_advtab":true,"file_picker_callback":"function(callback, value, meta) { if (meta.filetype === \'image\') { var input = document.createElement(\'input\'); input.setAttribute(\'type\', \'text\'); input.setAttribute(\'placeholder\', \'Enter image URL\'); input.oninput = function() { callback(input.value, {alt: \'\'}); }; document.body.appendChild(input); input.focus(); input.onblur = function() { document.body.removeChild(input); }; } }","fontsize_formats":"8pt 10pt 12pt 14pt 18pt 24pt 36pt","style_formats":[{"title":"Headers","items":[{"title":"Header 1","block":"h1"},{"title":"Header 2","block":"h2"},{"title":"Header 3","block":"h3"},{"title":"Header 4","block":"h4"},{"title":"Header 5","block":"h5"},{"title":"Header 6","block":"h6"}]},{"title":"Inline","items":[{"title":"Bold","icon":"bold","format":"bold"},{"title":"Italic","icon":"italic","format":"italic"},{"title":"Underline","icon":"underline","format":"underline"},{"title":"Strikethrough","icon":"strikethrough","format":"strikethrough"},{"title":"Superscript","icon":"superscript","format":"superscript"},{"title":"Subscript","icon":"subscript","format":"subscript"}]}],"content_style":"body { font-family:Helvetica,Arial,sans-serif; font-size:14px }"}}',
                'order' => 4,
            ),
            148 => 
            array (
                'id' => 163,
                'data_type_id' => 27,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            149 => 
            array (
                'id' => 164,
                'data_type_id' => 27,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 7,
            ),
            150 => 
            array (
                'id' => 165,
                'data_type_id' => 14,
                'field' => 'invoice_id',
                'type' => 'text',
                'display_name' => 'InvoiceID',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            151 => 
            array (
                'id' => 166,
                'data_type_id' => 28,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            152 => 
            array (
                'id' => 167,
                'data_type_id' => 28,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            153 => 
            array (
                'id' => 168,
                'data_type_id' => 28,
                'field' => 'files',
                'type' => 'text',
                'display_name' => 'Files',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 1,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            154 => 
            array (
                'id' => 169,
                'data_type_id' => 28,
                'field' => 'rejectionReason',
                'type' => 'text',
                'display_name' => 'Rejection Reason',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            155 => 
            array (
                'id' => 170,
                'data_type_id' => 28,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            156 => 
            array (
                'id' => 171,
                'data_type_id' => 28,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 8,
            ),
            157 => 
            array (
                'id' => 172,
                'data_type_id' => 19,
                'field' => 'message',
                'type' => 'text',
                'display_name' => 'Message',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            158 => 
            array (
                'id' => 173,
                'data_type_id' => 28,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"pending","options":{"pending":"Pending","rejected":"Rejected","verified":"Verified"}}',
                'order' => 6,
            ),
            159 => 
            array (
                'id' => 174,
                'data_type_id' => 19,
                'field' => 'withdrawal_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            160 => 
            array (
                'id' => 176,
                'data_type_id' => 4,
                'field' => 'wallet_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            161 => 
            array (
                'id' => 177,
                'data_type_id' => 9,
                'field' => 'notification_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'From',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"from_user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 3,
            ),
            162 => 
            array (
                'id' => 178,
                'data_type_id' => 9,
                'field' => 'notification_hasone_user_relationship_1',
                'type' => 'relationship',
                'display_name' => 'To',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"to_user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 5,
            ),
            163 => 
            array (
                'id' => 179,
                'data_type_id' => 9,
                'field' => 'withdrawal_id',
                'type' => 'text',
                'display_name' => 'Withdrawal Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 12,
            ),
            164 => 
            array (
                'id' => 180,
                'data_type_id' => 9,
                'field' => 'user_message_id',
                'type' => 'text',
                'display_name' => 'User Message Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 14,
            ),
            165 => 
            array (
                'id' => 181,
                'data_type_id' => 18,
                'field' => 'user_message_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Sender',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"sender_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            166 => 
            array (
                'id' => 182,
                'data_type_id' => 18,
                'field' => 'user_message_hasone_user_relationship_1',
                'type' => 'relationship',
                'display_name' => 'Receiver',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"receiver_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 4,
            ),
            167 => 
            array (
                'id' => 183,
                'data_type_id' => 12,
                'field' => 'reaction_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            168 => 
            array (
                'id' => 184,
                'data_type_id' => 16,
                'field' => 'user_list_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            169 => 
            array (
                'id' => 185,
                'data_type_id' => 17,
                'field' => 'user_list_member_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 5,
            ),
            170 => 
            array (
                'id' => 186,
                'data_type_id' => 17,
                'field' => 'user_list_member_hasone_user_list_relationship',
                'type' => 'relationship',
                'display_name' => 'List name',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\UserList","table":"user_lists","type":"hasOne","column":"id","key":"list_id","label":"name","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 3,
            ),
            171 => 
            array (
                'id' => 187,
                'data_type_id' => 11,
                'field' => 'post_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            172 => 
            array (
                'id' => 190,
                'data_type_id' => 10,
                'field' => 'post_comment_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            173 => 
            array (
                'id' => 191,
                'data_type_id' => 15,
                'field' => 'user_bookmark_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            174 => 
            array (
                'id' => 192,
                'data_type_id' => 1,
                'field' => 'birthdate',
                'type' => 'date',
                'display_name' => 'Birthdate',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 25,
            ),
            175 => 
            array (
                'id' => 193,
                'data_type_id' => 1,
                'field' => 'identity_verified_at',
                'type' => 'timestamp',
                'display_name' => 'ID verifed',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 26,
            ),
            176 => 
            array (
                'id' => 194,
                'data_type_id' => 29,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            177 => 
            array (
                'id' => 196,
                'data_type_id' => 29,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            178 => 
            array (
                'id' => 198,
                'data_type_id' => 29,
                'field' => 'details',
                'type' => 'text',
                'display_name' => 'Details',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            179 => 
            array (
                'id' => 199,
                'data_type_id' => 29,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Type',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
            'details' => '{"default":"I don\'t like this post","options":{"I don\'t like this post":"I don\'t like this post","Content is offensive or violates Terms of Service.":"Content is offensive or violates Terms of Service.","Content contains stolen material (DMCA)":"Content contains stolen material (DMCA)","Content is spam":"Content is spam","Report abuse":"Report abuse"}}',
                'order' => 9,
            ),
            180 => 
            array (
                'id' => 200,
                'data_type_id' => 29,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"received","options":{"received":"Received","seen":"Seen","solved":"Solved"}}',
                'order' => 10,
            ),
            181 => 
            array (
                'id' => 201,
                'data_type_id' => 29,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 11,
            ),
            182 => 
            array (
                'id' => 202,
                'data_type_id' => 29,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 12,
            ),
            183 => 
            array (
                'id' => 205,
                'data_type_id' => 30,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            184 => 
            array (
                'id' => 206,
                'data_type_id' => 30,
                'field' => 'email',
                'type' => 'text',
                'display_name' => 'Email',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            185 => 
            array (
                'id' => 207,
                'data_type_id' => 30,
                'field' => 'subject',
                'type' => 'text',
                'display_name' => 'Subject',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            186 => 
            array (
                'id' => 208,
                'data_type_id' => 30,
                'field' => 'message',
                'type' => 'text',
                'display_name' => 'Message',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            187 => 
            array (
                'id' => 209,
                'data_type_id' => 30,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            188 => 
            array (
                'id' => 210,
                'data_type_id' => 30,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 6,
            ),
            189 => 
            array (
                'id' => 223,
                'data_type_id' => 32,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            190 => 
            array (
                'id' => 224,
                'data_type_id' => 32,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            191 => 
            array (
                'id' => 225,
                'data_type_id' => 32,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            192 => 
            array (
                'id' => 226,
                'data_type_id' => 32,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 5,
            ),
            193 => 
            array (
                'id' => 227,
                'data_type_id' => 32,
                'field' => 'featured_user_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            194 => 
            array (
                'id' => 228,
                'data_type_id' => 33,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            195 => 
            array (
                'id' => 229,
                'data_type_id' => 33,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            196 => 
            array (
                'id' => 230,
                'data_type_id' => 33,
                'field' => 'transaction_id',
                'type' => 'text',
                'display_name' => 'Transaction Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            197 => 
            array (
                'id' => 231,
                'data_type_id' => 33,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"pending","options":{"pending":"Pending","rejected":"Rejected","approved":"Approved"}}',
                'order' => 5,
            ),
            198 => 
            array (
                'id' => 232,
                'data_type_id' => 33,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Type',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"deposit","options":{"deposit":"Deposit"}}',
                'order' => 6,
            ),
            199 => 
            array (
                'id' => 233,
                'data_type_id' => 33,
                'field' => 'reason',
                'type' => 'text',
                'display_name' => 'Reason',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            200 => 
            array (
                'id' => 234,
                'data_type_id' => 33,
                'field' => 'message',
                'type' => 'text',
                'display_name' => 'Message',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            201 => 
            array (
                'id' => 235,
                'data_type_id' => 33,
                'field' => 'amount',
                'type' => 'text',
                'display_name' => 'Amount',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            202 => 
            array (
                'id' => 236,
                'data_type_id' => 33,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            203 => 
            array (
                'id' => 237,
                'data_type_id' => 33,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 11,
            ),
            204 => 
            array (
                'id' => 238,
                'data_type_id' => 33,
                'field' => 'payment_request_hasmany_attachment_relationship',
                'type' => 'relationship',
                'display_name' => 'Files',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Attachment","table":"attachments","type":"hasMany","column":"payment_request_id","key":"id","label":"filename","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 12,
            ),
            205 => 
            array (
                'id' => 239,
                'data_type_id' => 11,
                'field' => 'price',
                'type' => 'text',
                'display_name' => 'Price',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            206 => 
            array (
                'id' => 240,
                'data_type_id' => 19,
                'field' => 'payment_method',
                'type' => 'text',
                'display_name' => 'Payment Method',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            207 => 
            array (
                'id' => 241,
                'data_type_id' => 19,
                'field' => 'payment_identifier',
                'type' => 'text',
                'display_name' => 'Payment Identifier',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            208 => 
            array (
                'id' => 242,
                'data_type_id' => 34,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 2,
            ),
            209 => 
            array (
                'id' => 243,
                'data_type_id' => 34,
                'field' => 'invoice_id',
                'type' => 'text',
                'display_name' => 'Invoice Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 1,
            ),
            210 => 
            array (
                'id' => 244,
                'data_type_id' => 34,
                'field' => 'data',
                'type' => 'text',
                'display_name' => 'Data',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            211 => 
            array (
                'id' => 245,
                'data_type_id' => 34,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            212 => 
            array (
                'id' => 246,
                'data_type_id' => 34,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 6,
            ),
            213 => 
            array (
                'id' => 247,
                'data_type_id' => 13,
                'field' => 'ccbill_subscription_id',
                'type' => 'text',
                'display_name' => 'Ccbill Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            214 => 
            array (
                'id' => 248,
                'data_type_id' => 13,
                'field' => 'provider',
                'type' => 'select_dropdown',
                'display_name' => 'Provider',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"credit","options":{"stripe":"Stripe","paypal":"Paypal","ccbill":"CCBill","credit":"Credit"}}',
                'order' => 12,
            ),
            215 => 
            array (
                'id' => 255,
                'data_type_id' => 1,
                'field' => 'auth_provider',
                'type' => 'text',
                'display_name' => 'Auth Provider',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 28,
            ),
            216 => 
            array (
                'id' => 256,
                'data_type_id' => 1,
                'field' => 'auth_provider_id',
                'type' => 'text',
                'display_name' => 'Auth Provider Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 29,
            ),
            217 => 
            array (
                'id' => 257,
                'data_type_id' => 1,
                'field' => 'enable_2fa',
                'type' => 'checkbox',
                'display_name' => 'Enable 2fa',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 30,
            ),
            218 => 
            array (
                'id' => 263,
                'data_type_id' => 27,
                'field' => 'page_order',
                'type' => 'text',
                'display_name' => 'Order',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            219 => 
            array (
                'id' => 264,
                'data_type_id' => 27,
                'field' => 'shown_in_footer',
                'type' => 'checkbox',
                'display_name' => 'Shown In Footer',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 5,
            ),
            220 => 
            array (
                'id' => 265,
                'data_type_id' => 19,
                'field' => 'fee',
                'type' => 'text',
                'display_name' => 'Fee',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            221 => 
            array (
                'id' => 266,
                'data_type_id' => 19,
                'field' => 'processed',
                'type' => 'text',
                'display_name' => 'Processed',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            222 => 
            array (
                'id' => 269,
                'data_type_id' => 14,
                'field' => 'coinbase_charge_id',
                'type' => 'text',
                'display_name' => 'Coinbase Charge Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 18,
            ),
            223 => 
            array (
                'id' => 270,
                'data_type_id' => 14,
                'field' => 'coinbase_transaction_token',
                'type' => 'text',
                'display_name' => 'Coinbase Transaction Token',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 20,
            ),
            224 => 
            array (
                'id' => 271,
                'data_type_id' => 14,
                'field' => 'nowpayments_payment_id',
                'type' => 'text',
                'display_name' => 'Nowpayments Payment Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 22,
            ),
            225 => 
            array (
                'id' => 272,
                'data_type_id' => 14,
                'field' => 'nowpayments_order_id',
                'type' => 'text',
                'display_name' => 'Nowpayments Order Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 24,
            ),
            226 => 
            array (
                'id' => 273,
                'data_type_id' => 14,
                'field' => 'ccbill_payment_token',
                'type' => 'text',
                'display_name' => 'Ccbill Payment Token',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 26,
            ),
            227 => 
            array (
                'id' => 274,
                'data_type_id' => 14,
                'field' => 'ccbill_transaction_id',
                'type' => 'text',
                'display_name' => 'Ccbill Transaction Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 28,
            ),
            228 => 
            array (
                'id' => 275,
                'data_type_id' => 14,
                'field' => 'ccbill_subscription_id',
                'type' => 'text',
                'display_name' => 'Ccbill Subscription Id',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 29,
            ),
            229 => 
            array (
                'id' => 276,
                'data_type_id' => 14,
                'field' => 'paystack_payment_token',
                'type' => 'text',
                'display_name' => 'Paystack Payment Token',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 30,
            ),
            230 => 
            array (
                'id' => 277,
                'data_type_id' => 33,
                'field' => 'payment_request_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Username',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"hasOne","column":"id","key":"user_id","label":"username","pivot_table":"attachments","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            231 => 
            array (
                'id' => 278,
                'data_type_id' => 35,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            232 => 
            array (
                'id' => 279,
                'data_type_id' => 35,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            233 => 
            array (
                'id' => 280,
                'data_type_id' => 35,
                'field' => 'description',
                'type' => 'text',
                'display_name' => 'Description',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            234 => 
            array (
                'id' => 281,
                'data_type_id' => 35,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"pending","options":{"pending":"Pending","published":"Published"}}',
                'order' => 4,
            ),
            235 => 
            array (
                'id' => 282,
                'data_type_id' => 35,
                'field' => 'order',
                'type' => 'text',
                'display_name' => 'Order',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            236 => 
            array (
                'id' => 283,
                'data_type_id' => 35,
                'field' => 'price',
                'type' => 'text',
                'display_name' => 'Price',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            237 => 
            array (
                'id' => 284,
                'data_type_id' => 35,
                'field' => 'yearly_price',
                'type' => 'text',
                'display_name' => 'Yearly Price',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            238 => 
            array (
                'id' => 285,
                'data_type_id' => 35,
                'field' => 'trial_days',
                'type' => 'text',
                'display_name' => 'Trial Days',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            239 => 
            array (
                'id' => 286,
                'data_type_id' => 35,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 17,
            ),
            240 => 
            array (
                'id' => 287,
                'data_type_id' => 35,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 18,
            ),
            241 => 
            array (
                'id' => 288,
                'data_type_id' => 35,
                'field' => 'default_plan',
                'type' => 'checkbox',
                'display_name' => 'Default Plan',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 9,
            ),
            242 => 
            array (
                'id' => 289,
                'data_type_id' => 35,
                'field' => 'display_logo',
                'type' => 'checkbox',
                'display_name' => 'Display Logo',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 10,
            ),
            243 => 
            array (
                'id' => 290,
                'data_type_id' => 35,
                'field' => 'highlight_ad',
                'type' => 'checkbox',
                'display_name' => 'Highlight Ad',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 11,
            ),
            244 => 
            array (
                'id' => 291,
                'data_type_id' => 35,
                'field' => 'main_page_pin',
                'type' => 'checkbox',
                'display_name' => 'Main Page Pin',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 12,
            ),
            245 => 
            array (
                'id' => 292,
                'data_type_id' => 35,
                'field' => 'share_on_slack',
                'type' => 'checkbox',
                'display_name' => 'Share On Slack',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 13,
            ),
            246 => 
            array (
                'id' => 293,
                'data_type_id' => 35,
                'field' => 'share_on_newsletter',
                'type' => 'checkbox',
                'display_name' => 'Share On Newsletter',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 14,
            ),
            247 => 
            array (
                'id' => 294,
                'data_type_id' => 35,
                'field' => 'share_on_partner_network',
                'type' => 'checkbox',
                'display_name' => 'Share On Partner Network',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 15,
            ),
            248 => 
            array (
                'id' => 295,
                'data_type_id' => 35,
                'field' => 'share_on_social_media',
                'type' => 'checkbox',
                'display_name' => 'Share On Social',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"On","off":"Off","checked":"true"}',
                'order' => 16,
            ),
            249 => 
            array (
                'id' => 311,
                'data_type_id' => 38,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            250 => 
            array (
                'id' => 312,
                'data_type_id' => 38,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            251 => 
            array (
                'id' => 313,
                'data_type_id' => 38,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            252 => 
            array (
                'id' => 314,
                'data_type_id' => 38,
                'field' => 'slug',
                'type' => 'text',
                'display_name' => 'Slug',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            253 => 
            array (
                'id' => 315,
                'data_type_id' => 38,
                'field' => 'hq',
                'type' => 'text',
                'display_name' => 'Hq',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            254 => 
            array (
                'id' => 316,
                'data_type_id' => 38,
                'field' => 'website_url',
                'type' => 'text',
                'display_name' => 'Website Url',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            255 => 
            array (
                'id' => 317,
                'data_type_id' => 38,
                'field' => 'email',
                'type' => 'text',
                'display_name' => 'Email',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            256 => 
            array (
                'id' => 318,
                'data_type_id' => 38,
                'field' => 'description',
                'type' => 'text',
                'display_name' => 'Description',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            257 => 
            array (
                'id' => 319,
                'data_type_id' => 38,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            258 => 
            array (
                'id' => 320,
                'data_type_id' => 38,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 11,
            ),
            259 => 
            array (
                'id' => 321,
                'data_type_id' => 39,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            260 => 
            array (
                'id' => 322,
                'data_type_id' => 39,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            261 => 
            array (
                'id' => 323,
                'data_type_id' => 39,
                'field' => 'min_range',
                'type' => 'text',
                'display_name' => 'Min Range',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            262 => 
            array (
                'id' => 324,
                'data_type_id' => 39,
                'field' => 'max_range',
                'type' => 'text',
                'display_name' => 'Max Range',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            263 => 
            array (
                'id' => 325,
                'data_type_id' => 39,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            264 => 
            array (
                'id' => 326,
                'data_type_id' => 39,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 6,
            ),
            265 => 
            array (
                'id' => 327,
                'data_type_id' => 41,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 1,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            266 => 
            array (
                'id' => 328,
                'data_type_id' => 41,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            267 => 
            array (
                'id' => 329,
                'data_type_id' => 41,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            268 => 
            array (
                'id' => 330,
                'data_type_id' => 41,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 6,
            ),
            269 => 
            array (
                'id' => 331,
                'data_type_id' => 41,
                'field' => 'description',
                'type' => 'text',
                'display_name' => 'Description',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            270 => 
            array (
                'id' => 332,
                'data_type_id' => 41,
                'field' => 'slogan',
                'type' => 'text',
                'display_name' => 'Slogan',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"validation":{"rule":"required"}}',
                'order' => 3,
            ),
            271 => 
            array (
                'id' => 338,
                'data_type_id' => 43,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            272 => 
            array (
                'id' => 339,
                'data_type_id' => 43,
                'field' => 'job_id',
                'type' => 'text',
                'display_name' => 'Job Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            273 => 
            array (
                'id' => 340,
                'data_type_id' => 43,
                'field' => 'skill_id',
                'type' => 'text',
                'display_name' => 'Skill Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            274 => 
            array (
                'id' => 341,
                'data_type_id' => 43,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            275 => 
            array (
                'id' => 342,
                'data_type_id' => 43,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 7,
            ),
            276 => 
            array (
                'id' => 343,
                'data_type_id' => 44,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            277 => 
            array (
                'id' => 344,
                'data_type_id' => 44,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            278 => 
            array (
                'id' => 345,
                'data_type_id' => 44,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            279 => 
            array (
                'id' => 346,
                'data_type_id' => 44,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            280 => 
            array (
                'id' => 348,
                'data_type_id' => 46,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            281 => 
            array (
                'id' => 349,
                'data_type_id' => 46,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            282 => 
            array (
                'id' => 350,
                'data_type_id' => 46,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            283 => 
            array (
                'id' => 351,
                'data_type_id' => 46,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            284 => 
            array (
                'id' => 352,
                'data_type_id' => 47,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            285 => 
            array (
                'id' => 353,
                'data_type_id' => 47,
                'field' => 'email',
                'type' => 'text',
                'display_name' => 'Email',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            286 => 
            array (
                'id' => 354,
                'data_type_id' => 47,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            287 => 
            array (
                'id' => 355,
                'data_type_id' => 47,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            288 => 
            array (
                'id' => 356,
                'data_type_id' => 48,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            289 => 
            array (
                'id' => 357,
                'data_type_id' => 48,
                'field' => 'range',
                'type' => 'text',
                'display_name' => 'Range',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            290 => 
            array (
                'id' => 358,
                'data_type_id' => 48,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            291 => 
            array (
                'id' => 359,
                'data_type_id' => 48,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 4,
            ),
            292 => 
            array (
                'id' => 368,
                'data_type_id' => 38,
                'field' => 'company_hasone_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Owner',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 3,
            ),
            293 => 
            array (
                'id' => 374,
                'data_type_id' => 13,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            294 => 
            array (
                'id' => 375,
                'data_type_id' => 13,
                'field' => 'job_id',
                'type' => 'text',
                'display_name' => 'Job Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            295 => 
            array (
                'id' => 376,
                'data_type_id' => 13,
                'field' => 'plan_id',
                'type' => 'text',
                'display_name' => 'Plan Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            296 => 
            array (
                'id' => 377,
                'data_type_id' => 14,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            297 => 
            array (
                'id' => 378,
                'data_type_id' => 14,
                'field' => 'job_id',
                'type' => 'text',
                'display_name' => 'Job Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            298 => 
            array (
                'id' => 379,
                'data_type_id' => 14,
                'field' => 'plan_id',
                'type' => 'text',
                'display_name' => 'Plan Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            299 => 
            array (
                'id' => 380,
                'data_type_id' => 52,
                'field' => 'company_id',
                'type' => 'text',
                'display_name' => 'Company Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 1,
            ),
            300 => 
            array (
                'id' => 381,
                'data_type_id' => 52,
                'field' => 'client_name',
                'type' => 'text',
                'display_name' => 'Client Name',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"Client name. If a company is provided, this parameter gets ignored."}',
                'order' => 4,
            ),
            301 => 
            array (
                'id' => 382,
                'data_type_id' => 52,
                'field' => 'client_logo',
                'type' => 'file',
                'display_name' => 'Client Logo',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"Client logo. If a company is provided, this parameter gets ignored."}',
                'order' => 5,
            ),
            302 => 
            array (
                'id' => 383,
                'data_type_id' => 52,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            303 => 
            array (
                'id' => 384,
                'data_type_id' => 52,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 8,
            ),
            304 => 
            array (
                'id' => 385,
                'data_type_id' => 52,
                'field' => 'featured_client_hasone_company_relationship',
                'type' => 'relationship',
                'display_name' => 'Company',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"If a company is provided, its name and avatar will be used","model":"App\\\\Model\\\\Company","table":"companies","type":"belongsTo","column":"company_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 3,
            ),
            305 => 
            array (
                'id' => 386,
                'data_type_id' => 52,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 2,
            ),
            306 => 
            array (
                'id' => 387,
                'data_type_id' => 53,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 3,
            ),
            307 => 
            array (
                'id' => 388,
                'data_type_id' => 53,
                'field' => 'category_id',
                'type' => 'text',
                'display_name' => 'Category Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 1,
            ),
            308 => 
            array (
                'id' => 389,
                'data_type_id' => 53,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            309 => 
            array (
                'id' => 390,
                'data_type_id' => 53,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 5,
            ),
            310 => 
            array (
                'id' => 392,
                'data_type_id' => 53,
                'field' => 'featured_category_belongsto_category_relationship',
                'type' => 'relationship',
                'display_name' => 'Category',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\JobCategory","table":"categories","type":"belongsTo","column":"category_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            311 => 
            array (
                'id' => 395,
                'data_type_id' => 21,
                'field' => 'hidden',
                'type' => 'checkbox',
                'display_name' => 'Hidden',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            312 => 
            array (
                'id' => 397,
                'data_type_id' => 53,
                'field' => 'order',
                'type' => 'text',
                'display_name' => 'Order',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            313 => 
            array (
                'id' => 398,
                'data_type_id' => 52,
                'field' => 'order',
                'type' => 'text',
                'display_name' => 'Order',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            314 => 
            array (
                'id' => 410,
                'data_type_id' => 54,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 1,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            315 => 
            array (
                'id' => 411,
                'data_type_id' => 54,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            316 => 
            array (
                'id' => 412,
                'data_type_id' => 54,
                'field' => 'title',
                'type' => 'text',
                'display_name' => 'Title',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            317 => 
            array (
                'id' => 413,
                'data_type_id' => 54,
                'field' => 'slug',
                'type' => 'text',
                'display_name' => 'Slug',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 11,
            ),
            318 => 
            array (
                'id' => 414,
                'data_type_id' => 54,
                'field' => 'status',
                'type' => 'text',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 12,
            ),
            319 => 
            array (
                'id' => 415,
                'data_type_id' => 54,
                'field' => 'company_id',
                'type' => 'text',
                'display_name' => 'Company Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            320 => 
            array (
                'id' => 416,
                'data_type_id' => 54,
                'field' => 'category_id',
                'type' => 'text',
                'display_name' => 'Category Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            321 => 
            array (
                'id' => 417,
                'data_type_id' => 54,
                'field' => 'type_id',
                'type' => 'text',
                'display_name' => 'Type Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            322 => 
            array (
                'id' => 418,
                'data_type_id' => 54,
                'field' => 'application_link',
                'type' => 'text',
                'display_name' => 'Application Link',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 13,
            ),
            323 => 
            array (
                'id' => 419,
                'data_type_id' => 54,
                'field' => 'description',
                'type' => 'text',
                'display_name' => 'Description',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 14,
            ),
            324 => 
            array (
                'id' => 420,
                'data_type_id' => 54,
                'field' => 'salary',
                'type' => 'text',
                'display_name' => 'Salary',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 15,
            ),
            325 => 
            array (
                'id' => 421,
                'data_type_id' => 54,
                'field' => 'location',
                'type' => 'text',
                'display_name' => 'Location',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 16,
            ),
            326 => 
            array (
                'id' => 422,
                'data_type_id' => 54,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 18,
            ),
            327 => 
            array (
                'id' => 423,
                'data_type_id' => 54,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 19,
            ),
            328 => 
            array (
                'id' => 424,
                'data_type_id' => 54,
                'field' => 'job_belongsto_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Owner',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 4,
            ),
            329 => 
            array (
                'id' => 425,
                'data_type_id' => 54,
                'field' => 'job_belongsto_company_relationship',
                'type' => 'relationship',
                'display_name' => 'Company',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Company","table":"companies","type":"belongsTo","column":"company_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 6,
            ),
            330 => 
            array (
                'id' => 428,
                'data_type_id' => 54,
                'field' => 'job_belongsto_category_relationship',
                'type' => 'relationship',
                'display_name' => 'Category',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\JobCategory","table":"categories","type":"belongsTo","column":"category_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 8,
            ),
            331 => 
            array (
                'id' => 429,
                'data_type_id' => 54,
                'field' => 'job_belongsto_job_type_relationship',
                'type' => 'relationship',
                'display_name' => 'Type',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\JobType","table":"job_types","type":"belongsTo","column":"type_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 10,
            ),
            332 => 
            array (
                'id' => 430,
                'data_type_id' => 54,
                'field' => 'job_hasone_subscription_relationship',
                'type' => 'relationship',
                'display_name' => 'SubscriptionID',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{"model":"App\\\\Model\\\\Subscription","table":"subscriptions","type":"hasOne","column":"job_id","key":"id","label":"id","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 17,
            ),
            333 => 
            array (
                'id' => 431,
                'data_type_id' => 43,
                'field' => 'job_skill_belongsto_job_relationship',
                'type' => 'relationship',
                'display_name' => 'Job Name',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{"model":"App\\\\Model\\\\JobListing","table":"jobs","type":"belongsTo","column":"job_id","key":"id","label":"title","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            334 => 
            array (
                'id' => 432,
                'data_type_id' => 13,
                'field' => 'subscription_belongsto_plan_relationship',
                'type' => 'relationship',
                'display_name' => 'Plan',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Plan","table":"plans","type":"belongsTo","column":"plan_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 7,
            ),
            335 => 
            array (
                'id' => 433,
                'data_type_id' => 13,
                'field' => 'subscription_belongsto_job_relationship',
                'type' => 'relationship',
                'display_name' => 'Job Title',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\JobListing","table":"jobs","type":"belongsTo","column":"job_id","key":"id","label":"title","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 5,
            ),
            336 => 
            array (
                'id' => 434,
                'data_type_id' => 34,
                'field' => 'invoice_hasone_transaction_relationship',
                'type' => 'relationship',
                'display_name' => 'Transaction Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{"model":"App\\\\Model\\\\Transaction","table":"transactions","type":"hasOne","column":"invoice_id","key":"id","label":"id","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 3,
            ),
            337 => 
            array (
                'id' => 435,
                'data_type_id' => 6,
                'field' => 'company_id',
                'type' => 'text',
                'display_name' => 'Company Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            338 => 
            array (
                'id' => 436,
                'data_type_id' => 6,
                'field' => 'attachment_belongsto_company_relationship',
                'type' => 'relationship',
                'display_name' => 'Company',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Company","table":"companies","type":"belongsTo","column":"company_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 4,
            ),
            339 => 
            array (
                'id' => 437,
                'data_type_id' => 6,
                'field' => 'attachment_belongsto_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Owner',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            340 => 
            array (
                'id' => 438,
                'data_type_id' => 13,
                'field' => 'subscription_belongsto_user_relationship',
                'type' => 'relationship',
                'display_name' => 'Owner',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 3,
            ),
            341 => 
            array (
                'id' => 440,
                'data_type_id' => 28,
                'field' => 'user_verify_belongsto_user_relationship',
                'type' => 'relationship',
                'display_name' => 'User',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            342 => 
            array (
                'id' => 441,
                'data_type_id' => 29,
                'field' => 'user_report_belongsto_user_relationship',
                'type' => 'relationship',
                'display_name' => 'User',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            343 => 
            array (
                'id' => 442,
                'data_type_id' => 29,
                'field' => 'job_id',
                'type' => 'text',
                'display_name' => 'Job Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            344 => 
            array (
                'id' => 443,
                'data_type_id' => 29,
                'field' => 'company_id',
                'type' => 'text',
                'display_name' => 'Company Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            345 => 
            array (
                'id' => 444,
                'data_type_id' => 29,
                'field' => 'user_report_belongsto_job_relationship',
                'type' => 'relationship',
                'display_name' => 'Job',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\JobListing","table":"jobs","type":"belongsTo","column":"job_id","key":"id","label":"title","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 4,
            ),
            346 => 
            array (
                'id' => 446,
                'data_type_id' => 29,
                'field' => 'user_report_belongsto_company_relationship',
                'type' => 'relationship',
                'display_name' => 'Company',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Company","table":"companies","type":"belongsTo","column":"company_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 6,
            ),
            347 => 
            array (
                'id' => 447,
                'data_type_id' => 43,
                'field' => 'job_skill_belongsto_skill_relationship',
                'type' => 'relationship',
                'display_name' => 'Skill',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Skill","table":"skills","type":"belongsTo","column":"skill_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 4,
            ),
            348 => 
            array (
                'id' => 448,
                'data_type_id' => 14,
                'field' => 'transaction_belongsto_user_relationship',
                'type' => 'relationship',
                'display_name' => 'User',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            349 => 
            array (
                'id' => 449,
                'data_type_id' => 14,
                'field' => 'transaction_belongsto_job_relationship',
                'type' => 'relationship',
                'display_name' => 'Job',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\JobListing","table":"jobs","type":"belongsTo","column":"job_id","key":"id","label":"title","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 4,
            ),
            350 => 
            array (
                'id' => 450,
                'data_type_id' => 14,
                'field' => 'transaction_belongsto_plan_relationship',
                'type' => 'relationship',
                'display_name' => 'Plans',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Model\\\\Plan","table":"plans","type":"belongsTo","column":"job_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 6,
            ),
            351 => 
            array (
                'id' => 451,
                'data_type_id' => 56,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            352 => 
            array (
                'id' => 452,
                'data_type_id' => 56,
                'field' => 'user_id',
                'type' => 'text',
                'display_name' => 'User Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            353 => 
            array (
                'id' => 453,
                'data_type_id' => 56,
                'field' => 'title',
                'type' => 'text',
                'display_name' => 'Title',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            354 => 
            array (
                'id' => 454,
                'data_type_id' => 56,
                'field' => 'slug',
                'type' => 'text',
                'display_name' => 'Slug',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{"description":"Blog URL path. EG: blog-title-name - domain.com\\/blog\\/blog-title-name"}',
                'order' => 5,
            ),
            355 => 
            array (
                'id' => 455,
                'data_type_id' => 56,
                'field' => 'cover',
                'type' => 'image',
                'display_name' => 'Cover',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"Blog image cover, panoramic aspect ratio images are required"}',
                'order' => 6,
            ),
            356 => 
            array (
                'id' => 456,
                'data_type_id' => 56,
                'field' => 'content',
                'type' => 'rich_text_box',
                'display_name' => 'Content',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
            'details' => '{"tinymceOptions":{"toolbar":"undo redo | formatselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | fontsizeselect","plugins":"lists link image","image_title":true,"automatic_uploads":false,"file_picker_types":"image","image_advtab":true,"file_picker_callback":"function(callback, value, meta) { if (meta.filetype === \'image\') { var input = document.createElement(\'input\'); input.setAttribute(\'type\', \'text\'); input.setAttribute(\'placeholder\', \'Enter image URL\'); input.oninput = function() { callback(input.value, {alt: \'\'}); }; document.body.appendChild(input); input.focus(); input.onblur = function() { document.body.removeChild(input); }; } }","fontsize_formats":"8pt 10pt 12pt 14pt 18pt 24pt 36pt","style_formats":[{"title":"Headers","items":[{"title":"Header 1","block":"h1"},{"title":"Header 2","block":"h2"},{"title":"Header 3","block":"h3"},{"title":"Header 4","block":"h4"},{"title":"Header 5","block":"h5"},{"title":"Header 6","block":"h6"}]},{"title":"Inline","items":[{"title":"Bold","icon":"bold","format":"bold"},{"title":"Italic","icon":"italic","format":"italic"},{"title":"Underline","icon":"underline","format":"underline"},{"title":"Strikethrough","icon":"strikethrough","format":"strikethrough"},{"title":"Superscript","icon":"superscript","format":"superscript"},{"title":"Subscript","icon":"subscript","format":"subscript"}]}],"content_style":"body { font-family:Helvetica,Arial,sans-serif; font-size:14px }"}}',
                'order' => 7,
            ),
            357 => 
            array (
                'id' => 457,
                'data_type_id' => 56,
                'field' => 'tags',
                'type' => 'text',
                'display_name' => 'Tags',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"Comma sepparated list of blog post tags"}',
                'order' => 8,
            ),
            358 => 
            array (
                'id' => 458,
                'data_type_id' => 56,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Status',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"1","options":{"1":"Draft","2":"Published"}}',
                'order' => 9,
            ),
            359 => 
            array (
                'id' => 459,
                'data_type_id' => 56,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            360 => 
            array (
                'id' => 460,
                'data_type_id' => 56,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 11,
            ),
            361 => 
            array (
                'id' => 461,
                'data_type_id' => 56,
                'field' => 'blog_post_belongsto_user_relationship',
                'type' => 'relationship',
                'display_name' => 'User',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\User","table":"users","type":"belongsTo","column":"user_id","key":"id","label":"name","pivot_table":"applicants","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            362 => 
            array (
                'id' => 624,
                'data_type_id' => 42,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            363 => 
            array (
                'id' => 625,
                'data_type_id' => 42,
                'field' => 'content',
                'type' => 'rich_text_box',
                'display_name' => 'Content',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"The .global-announcement-banner .content{} class can be used for additional styling."}',
                'order' => 2,
            ),
            364 => 
            array (
                'id' => 626,
                'data_type_id' => 42,
                'field' => 'is_published',
                'type' => 'checkbox',
                'display_name' => 'Is Published',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"True","off":"False","checked":"true","description":"If disabled, only admins will be able to see the banner"}',
                'order' => 3,
            ),
            365 => 
            array (
                'id' => 627,
                'data_type_id' => 42,
                'field' => 'is_dismissible',
                'type' => 'checkbox',
                'display_name' => 'Is Dismissible',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"True","off":"False","checked":"true"}',
                'order' => 4,
            ),
            366 => 
            array (
                'id' => 628,
                'data_type_id' => 42,
                'field' => 'is_global',
                'type' => 'checkbox',
                'display_name' => 'Is Global',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"True","off":"False","checked":"false","description":"If enabled, the banner will be shown on all pages, if not, it\'s only displayed on the homepage."}',
                'order' => 6,
            ),
            367 => 
            array (
                'id' => 629,
                'data_type_id' => 42,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            368 => 
            array (
                'id' => 630,
                'data_type_id' => 42,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 10,
            ),
            369 => 
            array (
                'id' => 631,
                'data_type_id' => 42,
                'field' => 'is_sticky',
                'type' => 'checkbox',
                'display_name' => 'Is Sticky',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"on":"True","off":"False","checked":"false"}',
                'order' => 5,
            ),
            370 => 
            array (
                'id' => 632,
                'data_type_id' => 42,
                'field' => 'expiring_at',
                'type' => 'timestamp',
                'display_name' => 'Expiring At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            371 => 
            array (
                'id' => 633,
                'data_type_id' => 42,
                'field' => 'size',
                'type' => 'select_dropdown',
                'display_name' => 'Size',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"regular","options":{"small":"Small","regular":"Regular"}}',
                'order' => 7,
            ),
        ));
        
        
    }
}