<?php

namespace App\Rules;

use App\Providers\JobListingsServiceProvider;
use Illuminate\Contracts\Validation\Rule;
use Str;

class Sluggable implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (JobListingsServiceProvider::slugify($value)) {
            return true;
        }

        return false;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('An URL can not be generated for this string.');
    }
}
