<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        'App\Console\Commands\CronClearDrafts',
        'App\Console\Commands\CronClearCache',
        'App\Console\Commands\CronClearDrafts',
        'App\Console\Commands\CronSubsReminder',
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('cron:clear_cache_files')->monthly();
        $schedule->command('cron:clear_draft_files')->weekly();
        $schedule->command('generateSitemap')->daily();
        $schedule->command('cron:subs_reminder')->daily();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        // Loading commands
        $this->load(__DIR__.'/Commands');

        // Forcing app url rewrite & HTPPS (if needed) on CLI mode
        // In order to get the right urls in the emails generated by the crons
        $url = $this->app['url'];
        $url->forceRootUrl(config('app.url'));
        if(is_int(strpos(config('app.url'), 'https'))){
            \URL::forceScheme('https');
        }

        require base_path('routes/console.php');
    }
}
